/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#ifndef WAYLANDBACKEND_WLSURFACEEVENT
#define WAYLANDBACKEND_WLSURFACEEVENT 1

#include <wayland-client.h>

namespace WaylandBackend
{

class WLSurfaceEvent
{
public:
    WLSurfaceEvent() { }
    virtual ~WLSurfaceEvent() { }
    virtual void keyboardEnter(void *seat, uint32_t serial,
                               struct wl_array* keys) = 0;
                               
    virtual void keyboardKeymap(void *seat, uint32_t format,
                                int fd, uint32_t size) = 0;

    virtual void keyboardModifiers(void *seat, uint32_t serial,
                       uint32_t mods_depressed, uint32_t mods_latched,
                       uint32_t mods_locked, uint32_t group) = 0;

    virtual void keyboardKey(void *seat, uint32_t serial,
                             uint32_t time, uint32_t key,
                             uint32_t state_w) = 0;
                            
    virtual void keyboardLeave(void *seat, uint32_t serial) = 0;
    
    virtual void keyboardRepeatInfo(void *seat, int32_t rate,
                                    int32_t delay) = 0;
                                        
    virtual void pointerEnter(void *seat, uint32_t serial,
                              double sx, double sy) = 0;
                            
    virtual void pointerMotion(void *seat, uint32_t time, double sx,
                               double sy) = 0;
                            
    virtual void pointerButton(void *seat, uint32_t serial, uint32_t time,
                              uint32_t button, uint32_t state) = 0;
	
	virtual void pointerAxis(void *seat, uint32_t time, uint32_t axis,
                             int value) = 0;

    virtual void pointerLeave(void *seat, uint32_t serial) = 0;
    
    
    virtual void touchDown(void *seat, uint32_t serial, uint32_t time,
                           int32_t id, double xw, double yw) = 0;

    virtual void touchMotion(void *seat, uint32_t time, int32_t id, double xw,
                             double yw) = 0;
                                  
    virtual void touchFrame(void *seat) = 0;
    
    virtual void touchCancel(void *seat) = 0;
    
    virtual void touchUp(void *seat, uint32_t serial, uint32_t time,
                         int32_t id) = 0;
    
    virtual void surfaceConfigured(int32_t width, int32_t height)
    {

    }
    virtual void surfaceConfigured(uint32_t edges, int32_t width, int32_t height)
    {

    }
private:

};

}

#endif
